//+-----------------------------------------------------------+
//| MT4 CUSTOM INDICATOR                   123PatternsV7.MQ4  |
//| copy to [experts\\indicators] and recompile or restart MT4 |
//+-----------------------------------------------------------+
//| Free software for personal non-commercial use only.       |
//| No guarantees are expressed or implied.                   |
//| Feedback welcome via Forex Factory private message.       |
//+-----------------------------------------------------------+
#property copyright "Copyright  2011 Robert Dee"
#property link      "www.forexfactory.com/robdee"

#define INDICATOR_VERSION    20111214         // VERSION 7 new approach focused on aggressive entries
#define INDICATOR_NAME       "123PatternsV7 BETA"
#define RELEASE_LEVEL        "Public BETA"
#define MT4_BUILD            409

#property indicator_chart_window
#property indicator_buffers 6
#property indicator_color1  DodgerBlue   // BuyLine
#property indicator_color2  OrangeRed    // SellLine
#property indicator_color3  DodgerBlue   // BullCandle
#property indicator_color4  OrangeRed    // BearCandle
#property indicator_color5  DodgerBlue   // BlueDot
#property indicator_color6  OrangeRed    // RedDot
#property indicator_width1  1            // BuyLine
#property indicator_width2  1            // SellLine
#property indicator_width3  3            // BullCandle
#property indicator_width4  3            // BearCandle
#property indicator_width5  1            // BlueDot
#property indicator_width6  1            // RedDot

extern string Notes           = "BETA TEST EURUSD M5 Setup";
extern bool   ShowBears       = True;
extern bool   ShowBulls       = True;
extern bool   ShowStatus      = True;
extern bool   ShowDots        = False;
extern bool   VolFilter       = True;
extern int    VolMaFast       = 12;
extern int    VolMaSlow       = 144;

// CCIFilter is disabled, plan for removal soon
bool   CCIFilter       = False;
int    CCIPeriod       = 144;
bool   TestMode        = False;

// indicator buffers
double BuyLine[];
double SellLine[];
double BullCandle[];
double BearCandle[];
double BlueDot[];
double RedDot[];

int     signal;
#define NOSIG   0
#define BUYSIG  10
#define SELLSIG 20

datetime signaltime, redrawtime, upperpeaktime, lowerpeaktime;
double   signalprice, upperpeak, lowerpeak, prevupperpeak, prevlowerpeak;
double   volmafast1, volmaslow1;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
SetIndexStyle(0,DRAW_LINE);
SetIndexStyle(1,DRAW_LINE);
SetIndexStyle(2,DRAW_HISTOGRAM);
SetIndexStyle(3,DRAW_HISTOGRAM);
SetIndexStyle(4,DRAW_ARROW); SetIndexArrow(4,159); // BullDot (WingDings character)
SetIndexStyle(5,DRAW_ARROW); SetIndexArrow(5,159); // BearDot (WingDings character)
SetIndexBuffer(0,BuyLine);
SetIndexBuffer(1,SellLine);
SetIndexBuffer(2,BullCandle);
SetIndexBuffer(3,BearCandle);
SetIndexBuffer(4,BlueDot);
SetIndexBuffer(5,RedDot);
SetIndexEmptyValue(0,EMPTY_VALUE);
SetIndexEmptyValue(1,EMPTY_VALUE);
SetIndexEmptyValue(2,EMPTY_VALUE);
SetIndexEmptyValue(3,EMPTY_VALUE);
SetIndexEmptyValue(4,EMPTY_VALUE);
SetIndexEmptyValue(5,EMPTY_VALUE);
SetIndexLabel(0,"BuyLine");
SetIndexLabel(1,"SellLine");
SetIndexLabel(2,"");
SetIndexLabel(3,"");
SetIndexLabel(4,"");
SetIndexLabel(5,"");
IndicatorShortName(INDICATOR_NAME);
IndicatorDigits(Digits);
if(IsTesting() == False)
   {
   Print("Copyright  2011 Robert Dee, All Rights Reserved");   
   Print("Free software for personal non-commercial use only. No guarantees are expressed or implied.");
   Print(INDICATOR_NAME+" indicator version "+INDICATOR_VERSION+" for "+RELEASE_LEVEL+" release, compiled with MetaTrader4 Build "+MT4_BUILD);
   }
} // end of init()

//+------------------------------------------------------------------+
//| Status Message prints below OHLC upper left of chart window
//+------------------------------------------------------------------+
void StatusMessage()
   {
   if(IsTesting() == True) return; // do no more
   if(ShowStatus == False) return; // do no more

   double move, pullback;
   double multi = MathPow(10,Digits-1);
   double dayhigh = iHigh(NULL,PERIOD_D1,0);
   double daylow = iLow(NULL,PERIOD_D1,0);
   double atr = iATR(NULL,PERIOD_D1,20,1); // yesterday's ATR(20)
   double range = dayhigh - daylow;
   double ratio = range / atr;
   double volratio = MathMax(Volume[1],Volume[0]) / volmaslow1;
   string msg = INDICATOR_NAME+"  "+TimeToStr(TimeCurrent(),TIME_MINUTES)+"  ";
   if(signalprice == BuyLine[0])
      {
      msg = msg + "BUY "+ TimeToStr(signaltime,TIME_MINUTES)+" "+DoubleToStr(signalprice,Digits)+" ";
      move = High[iHighest(NULL,0,MODE_HIGH,iBarShift(NULL,0,signaltime)+1,0)]-signalprice;
      pullback = signalprice-Low[iLowest(NULL,0,MODE_LOW,iBarShift(NULL,0,signaltime)+1,0)];
      msg = msg + "+"+DoubleToStr(move*multi,1)+" -"+DoubleToStr(pullback*multi,1)+"  ";
      }
   if(signalprice == SellLine[0])
      {
      msg = msg + "SELL "+ TimeToStr(signaltime,TIME_MINUTES)+" "+DoubleToStr(signalprice,Digits)+" ";
      move = signalprice-Low[iLowest(NULL,0,MODE_LOW,iBarShift(NULL,0,signaltime)+1,0)];
      pullback = High[iHighest(NULL,0,MODE_HIGH,iBarShift(NULL,0,signaltime)+1,0)]-signalprice;
      msg = msg + "+"+DoubleToStr(move*multi,1)+" -"+DoubleToStr(pullback*multi,1)+"  ";
      }
   msg = msg + "DR="+DoubleToStr(range*multi,1)+"  ";
   msg = msg + "ADR="+DoubleToStr(atr*multi,1)+"  ";
   msg = msg + "Ratio="+DoubleToStr(ratio,2)+"  ";
   msg = msg + "Vol="+DoubleToStr(volratio,2)+"  ";
   msg = msg + "Spread="+DoubleToStr((Ask-Bid)*multi,1)+"  ";
   Comment(msg);
   }

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
int    shift;
double range1, mid1, midlow1, midhigh1, nearlow1, nearhigh1;
 
///////////////////
// LOAD ARRAYS
if(redrawtime == Time[1])
   shift = 0; // process only the current candle, nothing else
else          // else this is a new candle so reload everything (once only)
   {
/***   
   if(CCIFilter == True) // load cci[] array
      {
      double ccima1, ccima6;
      double cci[100]; ArrayResize(cci,Bars); ArrayInitialize(cci,EMPTY_VALUE); ArraySetAsSeries(cci,True);
      shift = Bars-1;
      while(shift >= 0) {cci[shift] = iCCI(NULL,0,CCIPeriod,PRICE_CLOSE,shift); shift--;}
      }
***/
   if(VolFilter == True) // load vol[] array
      {
      double vol[100]; ArrayResize(vol,Bars); ArrayInitialize(vol,EMPTY_VALUE); ArraySetAsSeries(vol,True);
      shift = Bars-1;
      while(shift >= 0) {vol[shift] = Volume[shift]; shift--;}
      }
   shift = Bars-1;       // redraw the whole chart
   redrawtime = Time[1]; // remember this time
   } // end of else

///////////////////
// MAIN LOOP
// shift value is set in two places (above)
while(shift >= 0)
   {
/***
   if(CCIFilter == True)
      {
      ccima1 = iMAOnArray(cci,0,12,0,MODE_SMA,shift+1);
      ccima6 = iMAOnArray(cci,0,12,0,MODE_SMA,shift+6);
      }
***/
   if(VolFilter == True)
      {
      volmafast1 = NormalizeDouble(iMAOnArray(vol,0,VolMaFast,0,MODE_SMA,shift+1),0);
      volmaslow1 = NormalizeDouble(iMAOnArray(vol,0,VolMaSlow,0,MODE_SMA,shift+1),0);
      }
   if(iHighest(NULL,0,MODE_HIGH,5,shift) == shift+1)
      {prevupperpeak = upperpeak; upperpeak = High[shift+1]; upperpeaktime = Time[shift+1]; signal = NOSIG;}
   if(iLowest(NULL,0,MODE_LOW,5,shift) == shift+1)
      {prevlowerpeak = lowerpeak; lowerpeak = Low[shift+1]; lowerpeaktime = Time[shift+1]; signal = NOSIG;}
   range1 = High[shift+1]-Low[shift+1];
   mid1 = (High[shift+1]+Low[shift+1])/2;
   midlow1 = Low[shift+1]+(range1/3);
   midhigh1 = High[shift+1]-(range1/3);
   nearlow1 = Low[shift+1]+(range1/6);
   nearhigh1 = High[shift+1]-(range1/6);
   
   ///////////////////
   // SHOW DOTS
   if(ShowDots == True)
      {
      BlueDot[shift+1] = EMPTY_VALUE;
      RedDot[shift+1] = EMPTY_VALUE;
      RedDot[iBarShift(NULL,0,upperpeaktime)] = upperpeak+10*Point;
      BlueDot[iBarShift(NULL,0,lowerpeaktime)] = lowerpeak-10*Point;
      }
   
   ///////////////////
   // BEARISH SIGNAL
   if(ShowBears == True)
   if(signal != SELLSIG)
   if(Low[shift] < Low[shift+1]-5*Point)   // current candle breaks the signal candle low
   //if(Low[shift+1] < Low[shift+2]-5*Point) // signal candle breaks the prev candle low
   if(upperpeaktime > Time[shift+8])       // allows three candles only after the peak
   //if(CCIFilter == False || ccima1 > -125)
   if(VolFilter == False || volmafast1 > volmaslow1*1.09)      // THREE volume conditions, volume fastma > volume slowma
   if(VolFilter == False || Volume[shift+1] > volmaslow1)      // signal bar volume must be greater than slowma
   if(VolFilter == False || Volume[shift+1] > Volume[shift+2]) // signal bar must have greater volume than previous bar
   if(Open[shift+1] > midlow1 && Close[shift+1] < Open[shift+1])
   if(Close[shift+1] < nearlow1 || Close[shift+1] < lowerpeak)
      {
      BearCandle[shift+1] = Open[shift+1]; BullCandle[shift+1] = Close[shift+1];
      SellLine[shift+1] = Close[shift+1];
      SellLine[shift+2] = EMPTY_VALUE;
      BuyLine[shift+1] = Open[shift+1];
      BuyLine[shift+2] = EMPTY_VALUE;
      signal = SELLSIG;
      signalprice = SellLine[shift+1];
      signaltime = Time[shift];
      }
   
   ///////////////////
   // BULLISH SIGNAL
   if(ShowBulls == True)
   if(signal != BUYSIG)
   if(High[shift] > High[shift+1]+5*Point)   // current candle breaks the signal candle high
   if(High[shift+1] > High[shift+2]+5*Point) // signal candle breaks the prev candle high
   if(lowerpeaktime > Time[shift+6])         // allows three candles only after the peak
   //if(CCIFilter == False || ccima1 < 125)
   if(VolFilter == False || volmafast1 > volmaslow1*1.09)      // TWO volume conditions, volume fastma > volume slowma
   if(VolFilter == False || Volume[shift+1] > volmaslow1)      // signal bar volume must be greater than slowma
   if(Open[shift+1] < mid1 && Close[shift+1] > Open[shift+1])
   if(Close[shift+1] > nearhigh1 || Close[shift+1] > upperpeak)
      {
      BearCandle[shift+1] = Open[shift+1]; BullCandle[shift+1] = Close[shift+1];
      BuyLine[shift+1] = Close[shift+1];
      BuyLine[shift+2] = EMPTY_VALUE;
      SellLine[shift+1] = Open[shift+1];
      SellLine[shift+2] = EMPTY_VALUE;
      signal = BUYSIG;
      signalprice = BuyLine[shift+1];
      signaltime = Time[shift];
      }

   ///////////////////
   // CONTINUE LINES
   SellLine[shift] = SellLine[shift+1];
   BuyLine[shift] = BuyLine[shift+1];

   //////////////////////////
   // TESTMODE CODE BLOCK
   if(TestMode == True)
      {
      double ccival = iCCI(NULL,0,CCIPeriod,PRICE_CLOSE,shift+1);
      if(ccival < 0 && ccival > -125)
      if(lowerpeaktime < Time[shift+1])
      if(lowerpeaktime > Time[shift+6])
      if(Open[shift+1] < midlow1)
      if(Close[shift+1] > midhigh1)
         {BearCandle[shift+1] = Open[shift+1]; BullCandle[shift+1] = Close[shift+1];} // paint candle

      // debug data to Experts log
      //if(CCIFilter == True)Print("cci "+cci[0]+"  ccima1 "+ccima1);
      //if(VolFilter == True)Print("vol "+vol[0]+"  volmafast1 "+volmafast1+"  volmaslow1 "+volmaslow1);
      }

   shift--; // move ahead one candle
   } // end of while()

StatusMessage(); // update the status display
}// end of start()

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
// cleanup display buffers
for(int i=0; i<Bars; i++)
   {
   BuyLine[i] = EMPTY_VALUE;
   SellLine[i] = EMPTY_VALUE;
   BullCandle[i] = EMPTY_VALUE;
   BearCandle[i] = EMPTY_VALUE;
   BlueDot[i] = EMPTY_VALUE;
   RedDot[i] = EMPTY_VALUE;
   }
Comment("");   // clear the status display
}// end of deinit()


